IF OBJECT_ID('P_EST_SNGPC_SAIDA_VENDA_INCLUIR') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EST_SNGPC_SAIDA_VENDA_INCLUIR;
	END;
GO

CREATE PROCEDURE P_EST_SNGPC_SAIDA_VENDA_INCLUIR (@PCODIGOEMPRESA  INT
												 , @PCODIGOFILIAL   INT
												 , @PCODIGOLOTE     INT
												 , @PDATA           DATETIME
												 , @PQTDE           INT
												 , @PQTDEPRES       INT
												 , @PCODIGOUSUARIO  INT
												 , @PCODIGOVENDA    INT
												 , @PCODIGOITEM     INT
												 , @PCODIGORECEITA  INT
												 , @PCODIGOMOVVENDA INT)
AS

 
	 SET NOCOUNT ON; 

	 DECLARE
			@OUTTABLE TABLE(ID INT);
	 DECLARE
			@CODIGO INT;
	 DECLARE
			@DATA DATETIME;

	 DECLARE
			@ERROR VARCHAR(MAX);
	 DECLARE
			@OLDQTDE INT;
	 DECLARE
			@OLDLOTE INT;
	 DECLARE
			@NEWQTDE INT;
	 DECLARE
			@OPERACAO VARCHAR(MAX);
			  

	BEGIN TRY
		SET @DATA = GETDATE();
	 	SELECT @OLDQTDE = QT_LOTE
			 , @OLDLOTE = CD_LOTE
		FROM EST_SNGPC_SAIDA
		WHERE CD_SAI_SNGPC = @PCODIGOMOVVENDA;
		SET @NEWQTDE = @PQTDE;
		IF @OLDQTDE IS NULL
			BEGIN
				SET @OPERACAO = 'INSERT LANC. SAIDA';
				INSERT INTO EST_SNGPC_SAIDA
				(CD_EMP
			   , CD_FILIAL
			   , CD_LOTE
			   , DT_MOV
			   , QT_LOTE
			   , QT_PRES
			   , DT_ULT_ALT
			   , CD_USU
				)
				OUTPUT INSERTED.CD_SAI_SNGPC
					   INTO @OUTTABLE(ID)
				VALUES
				(@PCODIGOEMPRESA
			   , @PCODIGOFILIAL
			   , @PCODIGOLOTE
			   , @PDATA
			   , @PQTDE
			   , @PQTDEPRES
			   , @DATA
			   , @PCODIGOUSUARIO
				);

				SET @CODIGO =
				(
					SELECT MAX(ID)
					FROM @OUTTABLE
				);

				INSERT INTO PDV_VD_IT_EST_SNGPC_SAIDA
				(CD_SAI_SNGPC
			   , CD_EMP
			   , CD_FILIAL
			   , CD_VD
			   , CD_IT
				)
				VALUES
				(@CODIGO
			   , @PCODIGOEMPRESA
			   , @PCODIGOFILIAL
			   , @PCODIGOVENDA
			   , @PCODIGOITEM
				);

				INSERT INTO EST_SNGPC_SAIDA_RECEITA
				(CD_SAI_SNGPC
			   , CD_RECEITA
				)
				VALUES
				(@CODIGO
			   , @PCODIGORECEITA
				);
			END;
		ELSE
			BEGIN
				SET @OPERACAO = 'ATULIZACAO LANC. SAIDA';
				IF @OLDLOTE <> @PCODIGOLOTE
					BEGIN
						SET @OPERACAO = @OPERACAO+' ALT '+CAST(@OLDLOTE AS VARCHAR)+'  TO '+CAST(@PCODIGOLOTE AS VARCHAR);

						UPDATE EST_PROD_EST_SNGPC_LOTE_CPL
						  SET
							  QT_LOTE = (QT_LOTE - @OLDQTDE)
						WHERE CD_EMP = @PCODIGOEMPRESA
							  AND CD_FILIAL = @PCODIGOFILIAL
							  AND CD_LOTE = @OLDLOTE
							  AND (QT_LOTE - @OLDQTDE) >= 0;
						SET @OLDQTDE = 0;
					END;
				UPDATE EST_SNGPC_SAIDA
				  SET
					  DT_MOV = @PDATA
					, QT_LOTE = @PQTDE
					, QT_PRES = @PQTDEPRES
					, DT_ULT_ALT = @DATA
					, CD_USU = @PCODIGOUSUARIO
				WHERE CD_SAI_SNGPC = @PCODIGOMOVVENDA;
				SET @CODIGO = @PCODIGOMOVVENDA;
				UPDATE PDV_VD_IT_EST_SNGPC_SAIDA
				  SET
					  CD_EMP = @PCODIGOEMPRESA
				WHERE CD_SAI_SNGPC = @PCODIGOMOVVENDA;
			END;
		UPDATE EST_PROD_EST_SNGPC_LOTE_CPL
		  SET
			  QT_LOTE = (QT_LOTE + COALESCE(@OLDQTDE, 0)) - @NEWQTDE
		WHERE CD_EMP = @PCODIGOEMPRESA
			  AND CD_FILIAL = @PCODIGOFILIAL
			  AND CD_LOTE = @PCODIGOLOTE;
		INSERT INTO SNGPC_HIST_MOV_LOTE
		(CD_EMP
	   , CD_FILIAL
	   , CD_PROD
	   , LOTE
	   , TIPO_MOV
	   , CD_MOV
	   , DT_MOV
	   , CD_USU
	   , QT_MOV
		)
		VALUES
		(@PCODIGOEMPRESA
	   , @PCODIGOFILIAL
	   , 0
	   , @PCODIGOLOTE
	   , @OPERACAO
	   , @CODIGO
	   , GETDATE()
	   , @PCODIGOUSUARIO
	   , @PQTDE
		); 
	END TRY
	BEGIN CATCH
		SET @CODIGO = 0;
		SET @DATA = NULL;
		BEGIN TRY
			ROLLBACK;
		END TRY
		BEGIN CATCH
		END CATCH;

		SET @ERROR = ERROR_MESSAGE();
		RAISERROR(@ERROR, 16, 1);
	END CATCH;
	 SELECT @DATA AS DT_ULT_ALT
		  , @CODIGO AS CD_SAI_SNGPC;